CREATE OR REPLACE FUNCTION addColumn() 
RETURNS VOID AS 
$BODY$ 
BEGIN 
	
	IF EXISTS (SELECT 1 FROM pg_views 
                    WHERE viewname = 'v_rc_cli_crediario') THEN 
		DROP VIEW IF EXISTS v_rc_cli_crediario;
        RAISE NOTICE 'v_rc_cli_crediario removida.';
    END IF; 
	
	CREATE OR REPLACE VIEW public.v_rc_cli_crediario
	AS SELECT rc_cli_crediario.cd_emp,
		rc_cli_crediario.cd_cli,
		rc_cli.end_cli,
		rc_cli_crediario.cgc_cpf,
		rc_cli_crediario.rz_cli,
		rc_cli_crediario.vlr_lim_cred,
		rc_cli_crediario.vlr_deb_cred,
		rc_cli_crediario.vlr_lim_parc_cred,
		rc_cli_crediario.vlr_deb_parc_cred,
		rc_cli_crediario.cd_mdl_vd,
		rc_cli_crediario.qtde_max_parc_vd,
		rc_cli_crediario.sts_cred,
		rc_cli_crediario.vlr_lim_fat_cred,
		rc_cli_crediario.vlr_deb_fat_cred,
		''::text AS nr_cartao_antigo,
		rc_mdl_venda.ds_mdl_vd,
		rc_cli_crediario.dt_ult_fecha,
		rc_cli_crediario.dt_prox_fecha,
		rc_cli_crediario.nr_cartao,
		rc_mot_bloq_cli.ds_mot_bloq_cli,
		rc_mdl_venda.dia_vencto,
		rc_mdl_venda.dia_fecha,
		rc_mdl_venda.tipo_mdl_vd,
		rc_mdl_venda.tp_vencto,
		rc_mdl_venda.tp_fecha,
		rc_mdl_venda.vlr_min_parc,
		rc_cli_conv.flag_requer_senha,
		rc_cli.senha,
		rc_cli.exige_senha_compra,
		rc_mdl_venda.tp_perc_desc,
		rc_mdl_venda.perc_desc_pontual,
		rc_mdl_venda.perc_juros_atraso,
		rc_mdl_venda.perc_juros_multa,
		rc_mdl_venda.dias_bloq_atraso,
		rc_mdl_venda.num_max_parc_extra,
		rc_mdl_venda.vlr_acima_parc_extra,
		rc_mdl_venda.vlr_min_compra
	   FROM rc_cli_crediario
		 LEFT JOIN rc_mdl_venda ON rc_cli_crediario.cd_emp = rc_mdl_venda.cd_emp AND rc_cli_crediario.cd_mdl_vd = rc_mdl_venda.cd_mdl_vd
		 LEFT JOIN rc_mot_bloq_cli ON rc_cli_crediario.cd_mot_bloq_cli = rc_mot_bloq_cli.cd_mot_bloq_cli::numeric
		 LEFT JOIN rc_cli ON rc_cli_crediario.cd_emp = rc_cli.cd_emp AND rc_cli_crediario.cd_cli = rc_cli.cd_cli
		 LEFT JOIN rc_cli_conv ON rc_cli.cd_emp = rc_cli_conv.cd_emp AND rc_cli.cd_conv = rc_cli_conv.cd_conv;
	 
	ALTER TABLE v_rc_cli_crediario
	  OWNER TO postgres;
		
		
	RAISE NOTICE 'View v_rc_cli_crediario recriada.'; 
       
END; 
-- fim bloco principal 
$BODY$ 
LANGUAGE plpgsql VOLATILE 
  COST 100; 
ALTER FUNCTION addColumn() OWNER TO postgres; 
SELECT addColumn(); 
DROP FUNCTION addColumn();